;C prototype: short CollideSprite16 (short x0,short y0,short x1,short y1,short h,void *sprite0,void *sprite1)
;
;short CollideSprite16 (register short x0 asm ("%d0"),
;		       register short y0 asm ("%d1"),
;		       register short x1 asm ("%d2"),
;		       register short y1 asm ("%d3"),
;		       register short h asm ("%d4"),
;		       register void *sprite0 asm ("%a0"),
;		       register void *sprite1 asm ("%a1"));

	xdef CollideSprite16

CollideSprite16:
	;if (x0>x1)
	cmp.w	d2,d0
	bls.s	_x1_superior
	exg.w	d0,d2
	exg.w	d1,d3
	exg.l	a0,a1
_x1_superior:
	sub.w	d0,d2
	;dx->d2

	cmpi.w	#16,d2
	bge.s	_no_collide
	cmp.w	d3,d1
	bge.s	_y0_superior
	sub.w	d1,d3
	move.w	d3,d1
	add.w	d3,d3
	add.w	d3,a0
	bra.s	_continue1

_y0_superior:	
	sub.w	d3,d1
	move.w	d1,d3
	add.w	d3,d3
	add.w	d3,a1
_continue1:
	cmp.w	d4,d1
	bge.s	_no_collide

	addq.w	#1,d1
	move.w	(a0)+,d0
	move.w	(a1)+,d3
	lsr.w	d2,d3
	and.w	d3,d0
	tst.w	d0
	beq.s	_continue1
	moveq.l	#1,d0
	rts
		
_no_collide:
	moveq.l	#0,d0
	rts